#include <I2Cdev.h>
/*
-----------------------------------------------
Librairies Arduino 
-----------------------------------------------
I2C: https://github.com/jrowberg/i2cdevlib
ADS1115: https://github.com/addicore/ADS1115
-----------------------------------------------
Branchement Arduino-ADS1115:
----------------------------------------------- 
ADS1115 -->  UNO
  VDD        5V
  GND        GND
  SCL        A5 (or SCL)
  SDA        A4 (or SDA)
  ALRT       2
-----------------------------------------------  
*/

#include "ADS1115.h"

ADS1115 adc0(ADS1115_DEFAULT_ADDRESS);

// Paramètres 
const int alertReadyPin = 2;
const int AlarmePin=3; 
double ADC_mV=0.0; 
double Seuil_Alarme_mV=50.0; 

// Moyenne 
float Mean_val=0.0, Somme=0.0; 
int N=16, Count=0, i; 
int Val_TOR=0; 

void setup() {    
    //Connexion du bus I2C
    Wire.begin();

    // Init interface série 
    Serial.begin(115200); 

    // Test de la connectivité
    Serial.println("Testing device connections...");
    Serial.println(adc0.testConnection() ? "ADS1115 connexion réussie" : "ADS1115 connexion non établie");

    // Initiation du convertisseur ADS1115
    adc0.initialize(); 

    // Mode: Lecture unique (Il existe le mode continu!)
    adc0.setMode(ADS1115_MODE_SINGLESHOT);
    
    // Affectation de la fréquence d'échantillonnage (16SPS) 
    adc0.setRate(ADS1115_RATE_860);
      
    // Affectation du Gain
    adc0.setGain(ADS1115_PGA_0P512);

    // Connexion de l'indicateur de fin de conversion 
    pinMode(alertReadyPin,INPUT);
    adc0.setConversionReadyPinMode();

    // Alarme 
    pinMode(AlarmePin,OUTPUT);
}

void loop() 
{       
    /* Sélection de l'entrée (A0) */
    adc0.setMultiplexer(ADS1115_MUX_P0_NG);

    /* Lancement de la conversion */
    adc0.triggerConversion();

    /* Test la fin de la conversion */ 
    pollAlertReadyPin();

    /* Lecture du convertisseur en mV */
    ADC_mV=abs(adc0.getMilliVolts(false));

    /* Affichage des valeurs */  
    Serial.print(ADC_mV); 
    Serial.print(','); 
    Serial.print(Val_TOR); 
    Serial.print(','); 
    Serial.println(Mean_val);

    /* Calcul de la valeur moyenne */
    
    // Version 1
    for(i=0; i<N; i++)
    {
      adc0.triggerConversion();
      pollAlertReadyPin();
      ADC_mV=abs(adc0.getMilliVolts(false));
      Somme=Somme+ADC_mV; 
    }
    Mean_val=Somme/N; 
    Somme=0.0;
    
    // Version 2
    /*Somme=Somme+ADC_mV; 
    Count+=1; 
    if (Count==N)
    {
      Count=0;
      Mean_val=Somme/N; 
      Somme=Mean_val;
    }*/

    /* Conversion en valeur TOR */
    // Version 1
    /*if(Mean_val>150)
    {
      Val_TOR=300; 
    }
    else
    {
      Val_TOR=0;
    }*/
    // Version 2
    Val_TOR=floor(Mean_val/150)*300;

    // Attente (Attention à la fréquence de la mesure!)  
    delay(20);
}

// Fonction affichage de l'état de conversion après 100000 tentatives
void pollAlertReadyPin() 
{
  for (uint32_t i = 0; i<100000; i++)
    if (!digitalRead(alertReadyPin)) return;
   Serial.println("Failed to wait for AlertReadyPin, it's stuck high!");
}
