#include "IRremote.h"


// Numéro du pin sortie du récepteur 
long int res_val;
const int receiver = 11; 

// Indicateur de l'état de la charge  
const int RelaisON = 2;
const int RelaisOFF = 3;
int charge_etat=0;

// Relais de puissance  
const int RelaisPin = 10;

// Déclaration d'un objet IRrecv
IRrecv irrecv(receiver);           
decode_results results;            

void setup()  
{
  // Init relais  
  pinMode(RelaisPin, OUTPUT);
  
  // Init du récepteur 
  irrecv.enableIRIn();
  
  // Indicateur mise en marche/arrêt du relais 
  pinMode(RelaisON, OUTPUT);
  pinMode(RelaisOFF, OUTPUT);
  
  // Initialisation 
  digitalWrite(RelaisON, LOW);   
  digitalWrite(RelaisOFF, HIGH);                                        
  digitalWrite(RelaisPin, LOW); 
}

void loop()  
{
  // Lecture de la télécommande 
  if (irrecv.decode(&results))
  {
    // Récupération du code   
    res_val = results.value;
    
    // Commande de la charge 
    if (res_val==0xFF30CF) // Marche/Arrêt 
    {
      if (charge_etat==0)
      {
        // Allumé indicateur Arrêt 
        digitalWrite(RelaisOFF, HIGH); 
        digitalWrite(RelaisON, LOW); 

        // Mise en arrêt de la charge 
        digitalWrite(RelaisPin, LOW); 

        // Initialisation de l'état 
        charge_etat=1; 
      }
      else
      {
        // Allumé indicateur  marche  
        digitalWrite(RelaisOFF, LOW); 
        digitalWrite(RelaisON, HIGH); 

        // Mise en marche de la charge 
        digitalWrite(RelaisPin, HIGH); 

        // Initialisation de l'état 
        charge_etat=0; 
      }
    }
     
    // Réception de la nouvelle valeur
    irrecv.resume();
  }  
}
